import { Router } from 'express';
import { getBadges, createBadge } from '../controllers/index';
import { getQuizzes, createQuiz } from '../controllers/index';
import { getPosts, createPost } from '../controllers/index';
import { getUsers, createUser } from '../controllers/index';

const router = Router();

// Badge routes
router.get('/badges', getBadges);
router.post('/badges', createBadge);

// Quiz routes
router.get('/quizzes', getQuizzes);
router.post('/quizzes', createQuiz);

// Post routes
router.get('/posts', getPosts);
router.post('/posts', createPost);

// User routes
router.get('/users', getUsers);
router.post('/users', createUser);

export default router;